/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.apps.taskman.pa.peconnection;

import filenet.vw.apps.taskman.pa.peconnection.PEExposedLogField;
import filenet.vw.toolkit.utils.VWStringUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;

public class PEExposedLogFields {
    private ArrayList m_systemFields = new ArrayList();
    private ArrayList m_userFields = new ArrayList();

    public PEExposedLogField[] getFields(boolean bIncludeSystemFields) {
        ArrayList fields = this.getLogFields(bIncludeSystemFields);
        return fields.toArray(new PEExposedLogField[0]);
    }

    public PEExposedLogField[] getFields(boolean bIncludeSystemFields, int fieldType) {
        ArrayList fields = this.getLogFields(bIncludeSystemFields);
        Iterator i = fields.iterator();
        while (i.hasNext()) {
            if (((PEExposedLogField)i.next()).getFieldType() == fieldType) continue;
            i.remove();
        }
        return fields.toArray(new PEExposedLogField[0]);
    }

    private ArrayList getLogFields(boolean bIncludeSystemFields) {
        ArrayList fields = new ArrayList();
        if (bIncludeSystemFields) {
            fields.addAll(this.m_systemFields);
        }
        fields.addAll(this.m_userFields);
        Comparator fieldComparator = new Comparator(){

            public int compare(Object obj1, Object obj2) {
                return ((PEExposedLogField)obj1).getName().compareTo(((PEExposedLogField)obj2).getName());
            }

            public boolean equals(Object obj1) {
                return obj1 == this;
            }
        };
        Collections.sort(fields, fieldComparator);
        return fields;
    }

    protected void add(PEExposedLogField fieldDef) {
        ArrayList list = fieldDef.isSystemField() ? this.m_systemFields : this.m_userFields;
        String fieldName = fieldDef.getName();
        if (fieldDef.isSystemField() && VWStringUtils.compare(fieldName, "F_WobNum") != 0 && VWStringUtils.compare(fieldName, "F_WorkFlowNumber") != 0 && VWStringUtils.compare(fieldName, "F_Subject") != 0 && VWStringUtils.compare(fieldName, "F_Comment") != 0 && VWStringUtils.compare(fieldName, "F_Response") != 0 && VWStringUtils.compare(fieldName, "F_Text") != 0) {
            return;
        }
        int insertAt = list.size();
        for (int i = 0; i < list.size(); ++i) {
            PEExposedLogField def = (PEExposedLogField)list.get(i);
            String name = def.getName();
            int result = VWStringUtils.compare(fieldName, name);
            if (result == 0) {
                insertAt = -1;
                break;
            }
            if (result >= 0) continue;
            insertAt = i;
            break;
        }
        if (insertAt != -1) {
            list.add(insertAt, fieldDef);
        }
    }
}

